<?php
// ==========================================
// 1. CONFIGURATION (ISSE APNE HISAB SE CHANGE KARE)
// ==========================================
$api_url = 'https://zunopay.space/api/v1/order';
$merchant_id = 'MGA5XMCYES811765629852'; // Apani Merchant ID yahan dale
$secret_key  = '7ySJQhidYvyhxqm34KdY5U2Rn7NApOlO'; // Apna Secret Key yahan dale

// Redirect URL jahan payment ke baad user wapas aayega
$redirect_url = 'https://yourdomain.com/payment-success'; 

// ==========================================
// 2. BACKEND LOGIC (HANDLE FORM SUBMIT)
// ==========================================
$error_msg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['amount'])) {
    
    $amount = $_POST['amount'];
    
    // Basic Data Preparation
    $order_id = 'ORD' . time() . mt_rand(1, 999); // Unique Order ID
    $customer_mobile = '9876543210'; // Demo mobile number (ya form se input le sakte hain)
    
    // Data Array (Jo API ko bhejna hai)
    $data = [
        'customer_mobile' => $customer_mobile,
        'merch_id'        => $merchant_id,
        'amount'          => (int)$amount, // Ensure amount is integer
        'order_id'        => $order_id,
        'currency'        => 'INR',
        'redirect_url'    => $redirect_url,
        'udf1'            => 'Test Payment',
        'udf2'            => '',
        'udf3'            => '',
        'udf4'            => '',
        'udf5'            => '',
    ];

    // X-VERIFY GENERATION FUNCTION
    function generatexverify($data, $secret_key) {
        ksort($data); // Data ko key ke hisab se sort karna zaroori hai
        $dataString = implode('|', array_map(function ($key, $value) {
            return $key . '=' . $value;
        }, array_keys($data), $data));
        return hash_hmac('sha256', $dataString, $secret_key);
    }

    $xverify = generatexverify($data, $secret_key);
    $payload = json_encode($data);

    // cURL Request Setup
    $ch = curl_init($api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'X-VERIFY: ' . $xverify
    ]);
    
    // SSL Verification (Live server par ise True rakhein)
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);

    $response = curl_exec($ch);
    $curl_error = curl_error($ch);
    curl_close($ch);

    if ($curl_error) {
        $error_msg = "Connection Error: " . $curl_error;
    } else {
        $result = json_decode($response, true);

        // Check Logic
        if (isset($result['status']) && $result['status'] == true) {
            // SUCCESS: Redirect to Payment Page
            $payUrl = $result['result']['payment_url'];
            header("Location: " . $payUrl);
            exit();
        } else {
            // FAIL: Show Error
            $error_msg = "API Error: " . ($result['message'] ?? 'Unknown Error');
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LolaPay Payment Demo</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f6f9;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .payment-card {
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 400px;
            text-align: center;
        }
        h2 { margin-bottom: 20px; color: #333; }
        .form-group { margin-bottom: 20px; text-align: left; }
        label { display: block; margin-bottom: 8px; font-weight: 600; color: #555; }
        input[type="number"] {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 16px;
            box-sizing: border-box; /* Fix padding issue */
        }
        button {
            width: 100%;
            padding: 12px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: background 0.3s;
        }
        button:hover { background-color: #218838; }
        .error {
            background: #ffdddd;
            color: #d8000c;
            padding: 10px;
            border-radius: 6px;
            margin-bottom: 15px;
            font-size: 14px;
        }
    </style>
</head>
<body>

    <div class="payment-card">
        <h2>Pay with GarudHub</h2>
        
        <?php if (!empty($error_msg)): ?>
            <div class="error"><?php echo $error_msg; ?></div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="form-group">
                <label for="amount">Enter Amount (INR)</label>
                <input type="number" name="amount" id="amount" placeholder="e.g. 1" required min="1">
            </div>
            
            <button type="submit">Pay Now</button>
        </form>
        <p style="margin-top: 15px; font-size: 12px; color: #888;">Secured by LolaPay</p>
    </div>

</body>
</html>