<?php
// ===============================
// UPIExpress Webhook Receiver
// Save all incoming data to webhook.txt
// ===============================

// File where webhook data will be stored
$log_file = "webhook.txt";

// Get RAW JSON sent by gateway
$rawData = file_get_contents("php://input");

// If no data received
if (!$rawData) {
    die("No webhook data received");
}

// Decode JSON for validation (optional)
$data = json_decode($rawData, true);

// Create log format with date & time
$log_entry  = "==============================\n";
$log_entry .= "Webhook Received At: " . date("Y-m-d H:i:s") . "\n";
$log_entry .= "RAW DATA:\n" . $rawData . "\n";
$log_entry .= "==============================\n\n";

// Append log to file
file_put_contents($log_file, $log_entry, FILE_APPEND);

// Send success response to gateway
echo json_encode(["status" => "webhook_saved"]);
?>
