import android.os.Bundle
import android.util.Log
import androidx.appcompat.app.AppCompatActivity
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.http.Body
import retrofit2.http.POST

class CheckOrderStatusActivity : AppCompatActivity() {

    private val apiService by lazy { createApiService() }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        checkOrderStatus()
    }

    private fun checkOrderStatus() {
        val userToken = "2048f66bef68633fa3262d7a398ab577" // Replace with your API token
        val orderId = "9876543210" // Replace with the actual order ID

        val statusRequest = StatusRequest(user_token = userToken, order_id = orderId)

        apiService.checkOrderStatus(statusRequest).enqueue(object : retrofit2.Callback<StatusResponse> {
            override fun onResponse(call: retrofit2.Call<StatusResponse>, response: retrofit2.Response<StatusResponse>) {
                if (response.isSuccessful) {
                    val result = response.body()?.result
                    if (result?.txnStatus == "COMPLETED") {
                        Log.d("CheckOrderStatus", "Transaction Status: ${result.txnStatus}")
                        Log.d("CheckOrderStatus", "Order ID: ${result.orderId}")
                        Log.d("CheckOrderStatus", "Amount: ${result.amount}")
                        Log.d("CheckOrderStatus", "Date: ${result.date}")
                        Log.d("CheckOrderStatus", "UTR: ${result.utr}")
                    } else {
                        Log.e("CheckOrderStatus", "Error: ${response.body()?.message}")
                    }
                } else {
                    Log.e("CheckOrderStatus", "Request failed: ${response.message()}")
                }
            }

            override fun onFailure(call: retrofit2.Call<StatusResponse>, t: Throwable) {
                Log.e("CheckOrderStatus", "Failed to execute request: ${t.message}")
            }
        })
    }

    private fun createApiService(): ApiService {
        val retrofit = Retrofit.Builder()
            .baseUrl("https://pay.imb.org.in/api/")
            .addConverterFactory(GsonConverterFactory.create())
            .build()

        return retrofit.create(ApiService::class.java)
    }
}

data class StatusRequest(
    val user_token: String,
    val order_id: String
)

data class StatusResponse(
    val result: StatusResult
)

data class StatusResult(
    val txnStatus: String,
    val orderId: String,
    val amount: String,
    val date: String,
    val utr: String
)
