import io.ktor.application.*
import io.ktor.http.*
import io.ktor.request.*
import io.ktor.response.*
import io.ktor.routing.*
import io.ktor.server.engine.embeddedServer
import io.ktor.server.netty.Netty

fun main() {
    embeddedServer(Netty, port = 8080) {
        routing {
            post("/webhook") {
                val parameters = call.receiveParameters()
                val status = parameters["status"]
                val orderId = parameters["order_id"]
                val remark1 = parameters["remark1"]

                // Process webhook data
                when (status) {
                    "SUCCESS" -> {
                        println("Transaction successful for Order ID: $orderId")
                    }
                    "FAILD" -> {
                        println("Transaction failed for Order ID: $orderId")
                    }
                    else -> {
                        call.respond(HttpStatusCode.BadRequest, "Invalid status received")
                    }
                }
                call.respond(HttpStatusCode.OK)
            }
        }
    }.start(wait = true)
}
