import okhttp3.*
import org.json.JSONObject
import java.io.IOException
import kotlin.random.Random

fun main() {
    val url = "https://pay.imb.org.in/api/create-order"
    val orderId = Random.nextInt(123456789, 999999999)
    val token = "542a08bc000ceb2570dca59993610565"  // Replace with your API token
    
    val formBody = FormBody.Builder()
        .add("customer_mobile", "1234567890")
        .add("user_token", token)
        .add("amount", "2")
        .add("order_id", orderId.toString())
        .add("redirect_url", "https://your_Redirect_URL.in/")
        .add("remark1", "Customer-email@gmail.com")
        .add("remark2", "Additional data here")
        .build()
    
    val request = Request.Builder()
        .url(url)
        .post(formBody)
        .build()
    
    val client = OkHttpClient()
    client.newCall(request).enqueue(object : Callback {
        override fun onFailure(call: Call, e: IOException) {
            println("Failed to execute request: ${e.message}")
        }

        override fun onResponse(call: Call, response: Response) {
            response.use {
                if (it.isSuccessful) {
                    val jsonResponse = JSONObject(it.body!!.string())
                    val paymentUrl = jsonResponse.getJSONObject("result").getString("payment_url")
                    println("Redirect to Payment URL: $paymentUrl")
                } else {
                    println("Error: ${it.message}")
                }
            }
        }
    })
}
