const express = require('express');
const app = express();

// Middleware to parse URL-encoded data (IMB sends x-www-form-urlencoded)
app.use(express.urlencoded({ extended: true }));

app.post('/webhook', (req, res) => {
    const { status, order_id, remark1 } = req.body;
    
    // Log data for debugging
    const fs = require('fs');
    fs.appendFileSync('webhook_log.txt', JSON.stringify(req.body) + "\n");

    // Process webhook data
    if (status === "SUCCESS") {
        updateTransactionStatus(order_id, 'SUCCESS', remark1);
        res.send(`Transaction successful for Order ID: ${order_id}`);
    } else if (status === "FAILD") {
        updateTransactionStatus(order_id, 'FAILED', remark1);
        res.send(`Transaction failed for Order ID: ${order_id}`);
    } else {
        res.status(400).send("Invalid status received");
    }
});

function updateTransactionStatus(orderId, status, remark) {
    console.log(`Updating transaction ${orderId} to ${status} with remark: ${remark}`);
}

app.listen(5000, () => console.log('Webhook server is running on port 5000'));
