-- Database Schema for Payment Gateway System

-- 1. Users Table (Core for Admin & Merchants)
CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `mobile` varchar(20) NOT NULL UNIQUE,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` varchar(50) DEFAULT 'User', -- 'Admin' or 'User'
  `pin` varchar(10) DEFAULT '0000',
  `token` varchar(255) DEFAULT NULL,
  `active` tinyint(1) DEFAULT 1,
  `acc_ban` tinyint(1) DEFAULT 0,
  `acc_lock` tinyint(1) DEFAULT 0,
  `pg_mode` tinyint(1) DEFAULT 1,
  `two_factor` tinyint(1) DEFAULT 0,
  `otp` int(11) DEFAULT NULL,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 2. Website Settings (Global Configuration)
CREATE TABLE IF NOT EXISTS `website_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT 'Dragons Pay - Instant UPI Payments Solution',
  `logo` varchar(255) DEFAULT 'newassets/images/Logo.png',
  `favicon` varchar(255) DEFAULT 'newassets/images/favicon.png',
  `contact_email` varchar(255) DEFAULT 'info@pay.garudhub.in',
  `contact_phone` varchar(20) DEFAULT '+91 6200218694',
  `contact_address` text DEFAULT 'Delhi, India',
  `recaptcha_site_key` varchar(255) DEFAULT '6LcAbAgsAAAAAJ7cvR1PpoyHlChULeDsxaTZFtd-',
  `recaptcha_secret_key` varchar(255) DEFAULT '6LcAbAgsAAAAAB-2p85-_YLSWSQWAuhHiUGkb7dQ',
  `smtp_host` varchar(255) DEFAULT 'smtp.hostinger.com',
  `smtp_username` varchar(255) DEFAULT 'support@garudhub.in',
  `smtp_password` varchar(255) DEFAULT 'Raushan7x@@@',
  `smtp_port` int(11) DEFAULT 587,
  `smtp_encryption` varchar(10) DEFAULT 'tls',
  `smtp_from_email` varchar(255) DEFAULT 'support@garudhub.in',
  `smtp_from_name` varchar(255) DEFAULT 'Greenpay',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Default Settings
INSERT INTO `website_settings` (`id`, `title`, `logo`, `favicon`) VALUES
(1, 'Dragons Pay - Instant UPI Payments Solution', 'newassets/images/Logo.png', 'newassets/images/favicon.png')
ON DUPLICATE KEY UPDATE id=1;

-- 3. Orders Table (Transaction Logs)
CREATE TABLE IF NOT EXISTS `orders` (
  `order_id` varchar(255) NOT NULL,
  `user_token` varchar(255) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `status` varchar(50) DEFAULT 'PENDING',
  `utr` varchar(255) DEFAULT NULL,
  `customer_mobile` varchar(20) DEFAULT NULL,
  `payment_link` text DEFAULT NULL,
  `method` varchar(50) DEFAULT NULL,
  `redirect_url` text DEFAULT NULL,
  `date` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 4. Gateway Specific Tables (As per System Overview)

-- Amazon Pay
CREATE TABLE IF NOT EXISTS `amazon_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `phoneNumber` varchar(20) DEFAULT NULL,
  `upi_id` varchar(255) DEFAULT NULL,
  `cookie` text DEFAULT NULL,
  `user_token` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- BharatPe
CREATE TABLE IF NOT EXISTS `bharatpe_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_token` varchar(255) DEFAULT NULL,
  `phoneNumber` varchar(20) DEFAULT NULL,
  `token` text DEFAULT NULL,
  `cookie` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Google Pay
CREATE TABLE IF NOT EXISTS `gpay_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_token` varchar(255) DEFAULT NULL,
  `phoneNumber` varchar(20) DEFAULT NULL,
  `cokkie` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- PhonePe
CREATE TABLE IF NOT EXISTS `phnpe` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `user_token` varchar(255) DEFAULT NULL,
    `number` varchar(50) DEFAULT NULL,
    `cookie` text DEFAULT NULL,
    `device_id` varchar(255) DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Paytm
CREATE TABLE IF NOT EXISTS `paytm` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `user_token` varchar(255) DEFAULT NULL,
    `number` varchar(50) DEFAULT NULL,
    `cookie` text DEFAULT NULL,
    `mid` varchar(255) DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 5. Notifications
CREATE TABLE IF NOT EXISTS `notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_token` varchar(255) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `date` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 6. Callback Reports
CREATE TABLE IF NOT EXISTS `callback_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` varchar(255) DEFAULT NULL,
  `request_url` text DEFAULT NULL,
  `response` text DEFAULT NULL,
  `date` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
