import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@RestController
public class WebhookController {

    @PostMapping("/webhook")
    public ResponseEntity<String> handleWebhook(@RequestBody Map<String, String> payload) {
        String status = payload.get("status");
        String orderId = payload.get("order_id");
        String remark1 = payload.get("remark1");

        // Process webhook data
        if ("SUCCESS".equals(status)) {
            System.out.println("Transaction successful for Order ID: " + orderId);
        } else if ("FAILD".equals(status)) {
            System.out.println("Transaction failed for Order ID: " + orderId);
        } else {
            return ResponseEntity.badRequest().body("Invalid status received");
        }

        return ResponseEntity.ok("Webhook processed successfully");
    }
}
